function PageQuery(q) {
    if(q.length > 1) this.q = q.substring(1, q.length);
    else this.q = null;

    this.keyValuePairs = new Array();

    if(q) {
        for(var i=0; i < this.q.split("&").length; i++) {
            this.keyValuePairs[i] = this.q.split("&")[i];
        }
    }

    this.getKeyValuePairs = function() { return this.keyValuePairs; }
    this.getValue = function(s) {
        for(var j=0; j < this.keyValuePairs.length; j++) {
            if(this.keyValuePairs[j].split("=")[0] == s)
                return this.keyValuePairs[j].split("=")[1];
            }
        return false;
        }

    this.getParameters = function() {
        var a = new Array(this.getLength());

        for(var j=0; j < this.keyValuePairs.length; j++) {
            a[j] = this.keyValuePairs[j].split("=")[0];
        }
        return a;
    }

    this.getLength = function() { return this.keyValuePairs.length; }
}

function queryString(key){
    var page = new PageQuery(window.location.search);
    value = unescape(page.getValue(key));
    return value;
}

(function($) {
	hiConfig = {
		sensitivity:3,
		interval:200,
		timeout:200,
		over: function(){
			$(this).attr('background',$(this).css('background'));
			$(this).css('background-color','#f3f3f3');
			$(this).children('.cmsEdit:first').show('slow');
		},
		out: function(){
			
			$(this).css('background',$(this).attr('background'));
			$(this).children('.cmsEdit:first').hide('slow');
		}
	}
	//returnURIAfterEdit=&tabTV=SEOText
	$.fn.oneitEditable = function(pageIdent) {
		$('<div class="editPage"><a class="editPageLink" href="./editor/tabbedEdit.jsp?ident='+pageIdent+'&tabT1=Content&oneit.forceLock=true&returnURIAfterEdit=forceParentRefresh.jsp?fallback=' + escape(window.location) + '"><img src="images/editPage.jpg" alt="Edit Page" height="150" width="40" /></a></div>').appendTo('body');
		$('.editPage').append('<div class="preview"><h5>Preview:</h5><a class="previewLink" href="#">&nbsp;</a></div>');
        baseRequest = window.location.search;
        baseURL = window.location.protocol + "//" + window.location.host + window.location.pathname;

        linkURLOn =  baseURL + baseRequest.replace('&CMSpreview=noprocess','');
        linkURLOn =  linkURLOn.replace('?CMSpreview=noprocess','?');
        linkURLOff = (window.location.search.substring(1)) ? baseURL + window.location.search + "&CMSpreview=noprocess" : baseURL + "?CMSpreview=noprocess";

        //Uses current status
        if(queryString('CMSpreview')=='noprocess'){
            $('.previewLink').css("background-position","top left");
            $('.previewLink').attr('href',linkURLOn);
        } else {
            $('.previewLink').css("background-position","bottom left");
            $('.previewLink').attr('href',linkURLOff);
        }

		$('.editPageLink ').click(function(){
            height = ($(window).height() > 768) ? 768 : $(window).height();
			top_position = ($(window).height() > 768) ? ( height - 645 ) / 2+$(window).scrollTop() + "px" : "0px";
			left_position= ( $(window).width() - 1024 ) / 2+$(window).scrollLeft() + "px";
            height = height + "px";
			$('.editPage').animate({
				height: height,
				width: "1024px",
				top: top_position,
				left: left_position,
				border:"1px solid #3e3e3e"
				}, 500 );
			$('.editPage img').hide();
			url = $(this).attr('href');
			$('<iframe src="'+url+'" width="1024" height="' + height + '" border="0"></iframe>').prependTo('.editPage');
			return false;
		});
		
		return this.each(function(){	
			//Check to see is cmsIdent is defined
			if($(this).attr('cmsIdent')){
				cmsIdent = $(this).attr('cmsIdent');
				contentType = ($(this).attr('contentType')) ? '&tabTV=' + $(this).attr('contentType') : '';
				//Set position to relative if not already set
				if($(this).css('position') != 'absolute'){
					$(this).css('position','relative');
				};
				
				$(this).hoverIntent(hiConfig);
				
				$(this).children('.cmsEdit:first').css('height','300px');
				$('<a class="cmsEdit" href="./editor/tabbedEdit.jsp?ident='+cmsIdent+'&tabT1=Content&'+contentType+'&oneit.forceLock=true&returnURIAfterEdit=forceParentRefresh.jsp?fallback=' + escape(window.location) + '"><img src="images/editSection.jpg" alt="Edit Page" height="20" width="20" /></a>').prependTo(this);
				$('.cmsEdit').hide();	
				
				$(this).children('.cmsEdit:first').click(function(){
					height = ($(window).height() > 768) ? 768 : $(window).height();
                    top_position = ($(window).height() > 768) ? ( height - 645 ) / 2+$(window).scrollTop() + "px" : "0px";
                    left_position= ( $(window).width() - 1024 ) / 2+$(window).scrollLeft() + "px";
                    height = height + "px";
					$('.editPage').animate({
						height: height,
						width: "1024px",
						top: top_position,
						left: left_position,
						border:"1px solid #3e3e3e"
						}, 500 );
					$('.editPage img').hide();
					url = $(this).attr('href');
					$('<iframe src="'+url+'" width="1024" height="' + height + '"></iframe>').prependTo('.editPage');
					return false;
				});
			}
		})
	}
})(jQuery);